%define module_name WWW-CheckGzip
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Gzip/Faster.pm) perl(HTTP/Tiny.pm) perl(Data/Validate/URI.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: check web pages for correct gzipping of content
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BK/BKB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module offers a way to check a web page for correct gzip
compression. It tests the following, in the order given:

=over

=item Page OK with compression

The web page is retrievable with an Accept-Encoding header set.

If the page is not retrievable, the check entry elsewhere in this document calls the test callback,
then returns and does no further actions.

=item Header OK

When sent a request with an Accept-Encoding header containing the
string `gzip', the web page responds with a content encoding header.

=item Header is gzip

The content encoding header of the response is `gzip'.

=item Content is in gzip format

The content of the web page's response is in the gzip format. This is
checked using the gunzip entry in the Gzip::Faster manpage.

=item Content is smaller

The size of the uncompressed content of the web page is larger than it
is when compressed. This test will fail, for example, if gzip encoding
is wrongly used to compress images or extremely small web pages.

=item Page OK without compression

The web page is retrievable without an Accept-Encoding header set.

=item Response has no gzip header

The web page does not send a gzip header if the Accept-Encoding header
is not set.

=item Content is not compressed

The web page does not gzip compress the content when Accept-Encoding
header is not sent. This is checked using the gunzip entry in the Gzip::Faster manpage.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/W*

%files scripts
%_bindir/*

%changelog
