%define module_name WWW-Datafinder
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Config/IniFiles.pm) perl(Data/Dumper.pm) perl(DateTime/Format/ISO8601.pm) perl(Digest/MD5.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Path.pm) perl(File/Spec/Functions.pm) perl(JSON/XS.pm) perl(MCE.pm) perl(Mouse.pm) perl(REST/Client.pm) perl(Readonly.pm) perl(Scalar/Util.pm) perl(Search/Elasticsearch.pm) perl(Storable.pm) perl(Test/More.pm) perl(Test/Mouse.pm) perl(Text/CSV_XS.pm) perl(Try/Tiny.pm) perl(URI.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Perl API for Datafinder L<< http://datafinder.com >> API for marketing data append
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MANOWAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use WWW::Datafinder;
    use Text::CSV_XS;
    use Data::Dumper;

    my $csv = Text::CSV_XS->new;
    my $df  = WWW::Datafinder->new( {
          api_key    => '456', # place real API key here
          cache_dir  => '/var/tmp/datafinder',
          cache_time => 3600 * 24 * 14
    }) or die 'Cannot create Datafinder object';

    # process a CSV file with 6 columns:
    # First Name, Last Name, Address, City, State, ZIP
    while(<>) {
      chomp;
      my $status = $csv->parse($_);
      unless ($status) {
          warn qq{Cannot parse '$_':}.$csv->error_diag();
          next;
      }
      my ($name, $surname, $addr, $city, $state, $zip) = $csv->fields();
      my $data = {
            d_first    => $name,
            d_last     => $surname,
            d_fulladdr => $addr,
            d_city     => $city,
            d_state    => $state,
            d_zip      => $zip
      };
      my $res = $df->append_email($data);
      if ($res) {
        if ( $res->{'num-results'} ) {
            # there is a match!
            print "Got a match for $name $surname: " . Dumper( $res->{results} );
        }
      }
    }
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE README
%perl_vendor_privlib/W*

%changelog
