# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/HMAC_SHA1.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(HTTP/Request/Common.pm) perl(JSON.pm) perl(LWP.pm) perl(LWP/Simple.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.0.1
%define module_name WWW-Freebox
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.1
Release: alt1
Summary: Access to FreeboxOS API
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/V/VB/VBA/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Before using this module in your script(s) you need to acquire a token and a ID.

    use WWW::Freebox;
    
    my $fbx = WWW::Freebox->new("mafreebox.freebox.fr");
    
    my $app_id = "perl.helloworld";
    my $app_name = "Perl script";
    my $app_version = "1.0";
    my $device_name = "John's computer";
    
    # You have to launch this method only once because a unique token and a unique ID are required per application.
    my ($app_token, $track_id) = $fbx->authorize($app_id, $app_name, $app_version, $device_name);
    # You need to store $app_token and $track_id (in a config file for example)
    # You will have to grant access to your application (a message will be displayed on LCD screen of the Freebox Server)

Once you've got the token and the ID you will be able to use the module as follow : 
    
    use WWW::Freebox;
    
    my $fbx = WWW::Freebox->new("mafreebox.freebox.fr");
    
    $fbx->login("perl.helloworld", $app_token, $track_id);
    
    if($fbx->{permissions}{downloader}){
    _# Doing a request to FreeboxOS API
    _my $content = [download_dir => 'path', download_file => ['file.torrent']];
    _my $jsonResponse = $fbx->request("downloads/add", 1, $content);
    }
    
You can find more informations at http://dev.freebox.fr/sdk/os/.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes .git/description
%perl_vendor_privlib/W*

%changelog
