Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-WWW-Google-Contacts
Version:        0.39
Release:        alt2_23
Summary:        Use Perl to access, list and edit Google Contacts
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/WWW-Google-Contacts
Source0:        https://cpan.metacpan.org/authors/id/M/ME/MERIXZON/WWW-Google-Contacts-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(File/Slurp.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
BuildRequires:  perl(Moose.pm)
BuildRequires:  perl(Moose/Role.pm)
BuildRequires:  perl(MooseX/Role/Parameterized.pm)
BuildRequires:  perl(MooseX/Types.pm)
BuildRequires:  perl(MooseX/Types/Moose.pm)
BuildRequires:  perl(Net/Google/AuthSub.pm)
BuildRequires:  perl(Perl6/Junction.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Try/Tiny.pm)
BuildRequires:  perl(URI/Escape.pm)
BuildRequires:  perl(XML/Simple.pm)
# Tests
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(utf8.pm)
# Not needed but checked by Makefile.PL, stray specification probably
BuildRequires:  perl(Class/MOP.pm)
BuildRequires:  perl(Crypt/SSLeay.pm)

# The Requires that are commented are duplicates between cpanspec and
# automatic rpmbuild detection.
Requires:       perl(Class/MOP.pm) >= 1.090
Requires:       perl(Crypt/SSLeay.pm)
Source44: import.info
#Requires:       perl(File::Slurp)
#Requires:       perl(LWP::UserAgent)
#Requires:       perl(Moose)
#Requires:       perl(MooseX::Role::Parameterized)
#Requires:       perl(MooseX::Types)
#Requires:       perl(Net::Google::AuthSub)
#Requires:       perl(Perl6::Junction)
#Requires:       perl(Try::Tiny)
#Requires:       perl(XML::Simple)

%description
This module implements 'Google Contacts Data API' according to
http://code.google.com/apis/contacts/docs/3.0/developers_guide_protocol.html

%prep
%setup -q -n WWW-Google-Contacts-%{version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install

make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;

# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes dist.ini LICENSE README
%{perl_vendor_privlib}/*

%changelog
