# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(JSON.pm) perl(LWP.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name WWW-JSONAPI
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Very thin and inadequate wrapper for JSON APIs
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MI/MICHAEL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module contains utterly minimal functionality for interacting with JSON-based REST services with or without SSL.
It resulted from my development of the WWW::KeePassRest manpage, and has the purpose of providing a very thin but convenient
abstraction layer on top of LWP and JSON for that API. Other than those, it has no dependencies.
Version 0.01 contains only those methods needed by WWW::KeePassRest, so really it shouldn't even be considered
Version 0.01, but rather 0.00001 or so.

For a more feature-rich JSON module, you'll probably want the WWW::JSON manpage. Seriously. Anything but this one.

   use WWW::JSONAPI;
   
   my $json = WWW::JSONAPI->new(cert_file => 'cert/wwwkprcert.pem',
                                key_file  => 'cert/wwwkprkey.pem',
                                base_url  => 'https://localhost:12984/keepass/');
   
   my $hashref = $json->GET_json ("entry/$uuid");
   
The last request and response are always available if you have something else you want to do with them.

If the server responds with anything but a 200, the module croaks with the status line of the response.
Note that this also applies to 301/302 forwards and the like. Failure to connect is flagged with a `500 Can't connect ___'
error; this comes from LWP and is still grounds for croaking.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/W*

%changelog
