# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Test/Inline.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    WWW-Mechanize-FormFiller
%define upstream_version 0.13

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    WWW::Mechanize::FormFiller - framework to automate HTML forms
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/WWW/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Data/Random.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(HTML/Form.pm)
BuildRequires: perl(HTML/Tagset.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl-libwww
BuildArch:  noarch
Source44: import.info

%description
WWW::Mechanize::FormFiller and its submodules are useful to automate
web forms. The FormFiller object is filled with a set of rules how to
fill out HTML form field and then let loose on a HTML form. It fills
in the fields according to the preset rules.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

# pod2test is gone in perl-Test-Inline
perl -pi -e "s|pod2test|/bin/true|g" Makefile.PL

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build CFLAGS="%{optflags}"

%check
make test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml  README
%dir %{perl_vendor_privlib}/WWW/Mechanize/FormFiller
%dir %{perl_vendor_privlib}/WWW/Mechanize/FormFiller/Value
%dir %{perl_vendor_privlib}/WWW/Mechanize/FormFiller/Value/Random
%{perl_vendor_privlib}/WWW/Mechanize/FormFiller.pm
%{perl_vendor_privlib}/WWW/Mechanize/FormFiller/*.pm
%{perl_vendor_privlib}/WWW/Mechanize/FormFiller/Value/*.pm
%{perl_vendor_privlib}/WWW/Mechanize/FormFiller/Value/Random/*.pm

%changelog
