Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       perl-WWW-Mechanize-GZip 
Version:    0.14
Release:    alt2_17
# lib/WWW/Mechanize/GZip.pm -> GPL+ or Artistic
License:    GPL+ or Artistic 

Summary:    Fetch compressed web pages
Source:     https://cpan.metacpan.org/authors/id/P/PE/PEGI/WWW-Mechanize-GZip-%{version}.tar.gz
Url:        https://metacpan.org/release/WWW-Mechanize-GZip

BuildArch:  noarch

BuildRequires: rpm-build-perl
BuildRequires: perl(Compress/Zlib.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Pod.pm)
BuildRequires: perl(Test/Pod/Coverage.pm)
BuildRequires: perl(WWW/Mechanize.pm)

Requires:      perl(WWW/Mechanize.pm)
Requires:      perl(Compress/Zlib.pm)


Source44: import.info

%description
The WWW::Mechanize::GZip module tries to fetch a URL by requesting 
gzip-compression from the web server.  If the response contains
a header with 'Content-Encoding: gzip', it decompresses the response in
order to get the original (uncompressed) content. This module will help
to reduce bandwidth fetching web pages, if supported by the web server.
If the web server does not support gzip-compression, no decompression
will be made.


%prep
%setup -q -n WWW-Mechanize-GZip-%{version}
find . -type f -exec chmod -x -c {} \;

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc README Changes 
%{perl_vendor_privlib}/WWW*

%changelog
