# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(LWP.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name WWW-MelbourneBikeShare
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Simple interface to the Melbourne Bike Share open
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LT/LTP/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a simple interface to the Melbourne Bike Share open data 
set (https://data.melbourne.vic.gov.au/Transport-Movement/Melbourne-bike-share/tdvh-n9dv).

The Melbourne Bike Share open data set provides up to date information on the 
number of available bikes and slots available at each Melbourne Bike Share
terminal.  The data set also provides terminal metadata including; the terminal 
friendly name, the terminal ID, the terminal geographical coordinates, and a
time stamp indicating the time at which the terminal data was last updated.

_use WWW::MelbourneBikeShare;

_my $mbs = WWW::MelbourneBikeShare->new;

_# Get a list of all Melbourne Bike Share terminals as an array of
_# WWW::MelbourneBikeShare::Terminal objects.

_my @terminals = $mbs->terminals;

_# Print the ID, name, and number of bikes available at each terminal.
_
_map { 
__printf( "%%-3s %%-65 %%-4s\n", $_->id, $_->name, $_->bikes )
_} @terminals;

_# Do the same thing, but order the list by the number of available bikes.
_map {
__printf( "%%-3s %%-65 %%-4s\n", $_->id, $_->name, $_->bikes 
_} $mbs->by_available_bikes;

_# Or, by proximity to our current location.
_map { 
__printf( "%%-3s %%-65 %%-4s\n", $_->id, $_->name, $_->bikes 
_} $mbs->by_distance( -37.816181, 144.952688 );

_# Get our closest terminal.
_my $t = $mbs->nearest( -37.816181, 144.952688 );

_# And print some information about it.
_print "Our closest terminal is " . $t->name
__." (ID ". $t->id . ") "
__." located approximately ". $t->distance( -37.816181, 144.952688 )
__."km away at ". $t->lat ", ". $t->lon .".\n\n"
__."The terminal currently has ". $t->bikes ." bikes available and "
__. $t->empty . " empty slots.\n\n";
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md README Changes
%perl_vendor_privlib/W*

%changelog
