%define module_name WWW-OAuth
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Tiny/Chained.pm) perl(Crypt/URandom.pm) perl(Data/Dumper.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(HTTP/Tiny.pm) perl(JSON/PP.pm) perl(List/Util.pm) perl(Module/Runtime.pm) perl(Mojo/Content/MultiPart.pm) perl(Mojo/Message/Request.pm) perl(Mojo/Parameters.pm) perl(Mojo/URL.pm) perl(Mojolicious.pm) perl(Role/Tiny.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Needs.pm) perl(URI.pm) perl(URI/Escape.pm) perl(WWW/Form/UrlEncoded.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.002
Release: alt1
Summary: Portable OAuth 1.0 authentication
Group: Development/Perl
License: artistic_2
URL: https://github.com/Grinnz/WWW-OAuth

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBOOK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the WWW::OAuth manpage implements OAuth 1.0 request authentication according to
RFC 5849. It does not implement the user
agent requests needed for the complete OAuth 1.0 authorization flow; it only
prepares and signs requests, leaving the rest up to your application. It can
authenticate requests for the LWP::UserAgent manpage, the Mojo::UserAgent manpage, the HTTP::Tiny manpage,
and can be extended to operate on other types of requests.

Some user agents can be configured to automatically authenticate each request
with a the WWW::OAuth manpage object.

 # LWP::UserAgent
 my $ua = LWP::UserAgent->new;
 $ua->add_handler(request_prepare => sub { $oauth->authenticate($_[0]) });
 
 # Mojo::UserAgent
 my $ua = Mojo::UserAgent->new;
 $ua->on(start => sub { $oauth->authenticate($_[1]->req) });
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING.md LICENSE Changes README
%perl_vendor_privlib/W*

%changelog
