%define module_name WWW-Oxontime
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/Tree.pm) perl(HTTP/Tiny.pm) perl(JSON/MaybeXS.pm) perl(JSON/XS.pm) perl(Test/RequiresInternet.pm) perl(Time/Piece.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: live Oxford bus departures from Oxontime
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module wraps http://www.oxontime.com to provide live bus
departures in Oxford.

Two methods can be exported (none by default):

=over

=item stops_for_route(*$route_id*)

Given a route ID (these can be obtained by inspecting the homepage of
Oxontime), returns in list context a list of hashrefs having the keys
`stopName' (name of stop) and `stopId' (ID of stop, suitable for
passing to `departures_for_stop'). In scalar context, an arrayref
containing this list is returned.

=item departures_for_stop(*$stop_id*)

Given a stop ID (these can be obtained by inspecting the homepage of
Oxontime or by calling `stops_for_route'), returns in list context a
list of hashrefs having the keys `service' (name of service and
company that runs it), `destination' (where the service is finishing)
and `departs' (the Time::Piece manpage object representing the time when the
service departs). In scalar context, an arrayref containing the list
is returned.

Note that `departs' is in the time zone of Oxford, but Time::Piece
interprets it as being in local time. If local time is different from
time in Oxford, this needs to be taken into account.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/W*

%changelog
