# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Test/Pod.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    WWW-Shorten-Simple
%define upstream_version 0.02

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Factory wrapper around WWW::Shorten to avoid imports
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/WWW/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Module/Build/Tiny.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(WWW/Shorten.pm)
BuildArch:  noarch
Source44: import.info

%description
WWW::Shorten::Simple is a wrapper (factory) around WWW::Shorten so that you
can create an object representing each URL shortening service, instead of
_import_ing 'makeashorterlink' function into your namespace.

This allows you to call multiple URL shortening services in one package,
for instance to call the WWW::Shorten::RevCanonical manpage to extract
rev="canonical", fallback to bit.ly if username and API key are present,
and then finally to TinyURL.

  use WWW::Shorten::Simple;

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL --installdirs=vendor

./Build CFLAGS="%{optflags}"

%check
./Build test

%install
./Build install --destdir=%{buildroot}

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*

%changelog
