%define module_name WWW-Subsonic
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CLI/Helpers.pm) perl(Data/Printer.pm) perl(Digest/MD5.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Getopt/Long/Descriptive.pm) perl(HTML/Entities.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(JSON/MaybeXS.pm) perl(List/Util.pm) perl(Mojo/UserAgent.pm) perl(Moo.pm) perl(Net/Netrc.pm) perl(Path/Tiny.pm) perl(Pod/Coverage/TrustPod.pm) perl(Storable.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Types/Standard.pm) perl(URI.pm) perl(URI/QueryParam.pm) perl(feature.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(utf8.pm) perl(version.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.010
Release: alt1
Summary: Interface with the Subsonic API
Group: Development/Perl
License: bsd
URL: https://github.com/reyjrar/WWW-Subsonic

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BL/BLHOTSKY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a very simple interface to using the Subsonic API.

    use Path::Tiny;
    use WWW::Subsonic;

    my $subsonic = WWW::Subsonic->new(
        username => 'user1',
        password => 'Assw0rd1P',
    );

    my $pinged = $subsonic->api_request('ping.view');

    my $starred = $subsonic->api_request('getStarred2');

    foreach my $song (@{ $starred->{song} }) {
        my $dst = path($song->{path});
        $dst->parent->mkpath;
        $dst->spew_raw( $subsonic->api_request(download => { id => $song->{id} }) );
    }

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.mkdn LICENSE
%perl_vendor_privlib/W*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
