# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(Mojolicious.pm) perl(Test/More.pm) perl(WWW/Suffit.pm)
# END SourceDeps(oneline)
%define module_name WWW-Suffit-Plugin-FileAuth
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: The Suffit plugin for authentication and authorization by password file
Group: Development/Perl
License: perl
URL: https://sourceforge.net/projects/www-suffit-plugin-fileauth/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AB/ABALAMA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This plugin provides authentication and authorization by looking up users in plain text password files

The `AuthUserFile' configuration directive sets the path to the user file of a textual file containing the list of users and passwords
for user authentication.

If it is not absolute, it is treated as relative to the project `data' directory.

By default use `passwd.db' file name

Each line of the user file contains a username followed by a colon, followed by the encrypted password.
If the same user ID is defined multiple times, plugin will use the first occurrence to verify the password.
Try to avoid such cases!

The encrypted password format depends on which length of this encrypted-string and character-set:

    md5     32 hex digits and chars
    sha1    40 hex digits and chars
    sha224  56 hex digits and chars
    sha256  64 hex digits and chars
    sha384  96 hex digits and chars
    sha512  128 hex digits and chars
    unsafe plain text otherwise

Also, each line of the user file can contain parameters in the `Query of URL' format
(RFC 3986), which must be placed at the end of the line with
a leading colon character, which is the delimiter

For example:

    admin:5f4dcc3b5aa765d61d8327deb882cf99
    test:5f4dcc3b5aa765d61d8327deb882cf99:uid=1&name=Test%%20user
    anonymous:password

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE TODO INSTALL.md README.md Changes
%perl_vendor_privlib/W*

%changelog
