# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name WWW-TMDB-API
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: TMDb API (http://api.themoviedb.org) client
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MA/MARIAB/%{module_name}%{module_version}.tar.gz
BuildArch: noarch

%description
This module implements version 3 of the TMDb API. See http://help.themoviedb.org/kb/api/about-3 for the documentation.
The module uses the same parameter names used by the API. 
The method names have been slightly changed. Here's the mapping of the method names used by this this module and the corresponding method names in the TMDb API:

                                      TMDB API                           WWW::TMDB::API
                                      ----------------------             -------------------
    Search Movies                     search/movie_                 movie->search() 
    Search People                     search/person                      person->search()
    Movie Info                        movie/[TMDb ID]                    movie->info()
    Movie Alternative Titles          movie/[TMDb ID]/alternative_titles movie->alternative_titles()
    Movie Casts                       movie/[TMDb ID]/casts              movie->casts()
    Movie Images                      movie/[TMDb ID]/images             movie->images()
    Movie Keywords                    movie/[TMDb ID]/keywords           movie->keywords()
    Movie Release Info                movie/[TMDb ID]/releases           movie->releases()
    Movie Trailers                    movie/[TMDb ID]/trailers           movie->trailers()
    Movie Translations                movie/[TMDb ID]/translations       movie->translations()
    Person Info                       person/[TMDb ID]/info              person->info()
    Person Credits                    person/[TMDb ID]/credits           person->credits()
    Person Images                     person/[TMDb ID]/images            person->images()
    Latest Movie                      latest/movie                       movie->latest()


The API requires an API key which can be generated from http://api.themoviedb.org.
This module converts the API output to Perl data structure using the module JSON.
This module does not support update the method, Movie Add Rating.


%prep
%setup -n %{module_name}%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/W*

%changelog
