%def_without test
%define module_name WWW-Trello-Lite
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(HTTP/Tiny.pm) perl(IO/Socket/SSL.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Net/SSLeay.pm) perl(Parse/CPAN/Meta.pm) perl(Role/REST/Client.pm) perl(Role/REST/Client/Response.pm) perl(Socket.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(URI/Escape.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Simple wrapper around the Trello web service.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RB/RBWOHLFAR/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
Trello manages lists of *stuff*.
Trello provides an API for remote control.
WWW::Trello::Lite provides Perl scripts easy access to the API. I use it
to add cards on my to-do list.

Translating the Trello API documentation into functional calls is straight
forward.

  # Trello API documentation says:
  # GET /1/cards/[card_id]
  my $card = $trello->get( "cards/$id" );

The first word (*GET*, *POST*, *PUT*, *DELETE*) becomes the method call.
Ignore the number. That is the Trello API version number. WWW::Trello::Lite
handles that for you automatically.

The rest of the API URL slides into the first parameter of the method.

Some API calls, such as this one, also accept Arguments. Pass the arguments
as a hash reference in the second parameter. The argument name is a key. And
the argument value is the value.

  # Trello API documentation says:
  # GET /1/cards/[card_id]
  my $card = $trello->get( "cards/$id", {attachments => 'true'} );


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/W*

%changelog
