%def_without test
%define module_name WWW-Tumblr
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(LWP/UserAgent.pm) perl(Moose.pm) perl(Net/OAuth/Client.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 5.3
Release: alt1
Summary: Perl bindings for the Tumblr API
Group: Development/Perl
License: perl
URL: http://github.com/damog/www-tumblr

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAMOG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module makes use of some sort of the same models as the upstream API,
meaning that you will have User, Blog and Tagged methods:

  my $t = WWW::Tumblr->new(
    consumer_key    => $consumer_key,
    secret_key      => $secret_key,
    token           => $token,
    token_secret    => $token_secret,
  );

  # Once you have a WWW::Tumblr object, you can get a WWW::Tumblr::Blog object
  # by calling the blog() method from the former object:
  
  my $blog = $t->blog('perlapi.tumblr.com');
 
  # And then just use WWW::Tumblr::Blog methods from it:
  if ( my $post = $blog->post( type => 'text', body => 'Hell yeah, son!' ) ) {
     say "I have published post id: " . $post->{id};    
  } else {
     print STDERR Dumper $blog->error;
     die "I couldn't post it :(";
  }

You can also work directly with a the WWW::Tumblr::Blog manpage class for example:

  # You will need to set base_hostname:
  my $blog = WWW::Tumblr::Blog->new(
     %%%%four_tokens,
     base_hostname => 'myblogontumblr.com'
  );

All operation methods on the entire API will return false in case of an
upstream error and you can check the status with `error()':

  die Dumper $blog->error unless $blog->info();

On success, methods will return a hash reference with the JSON representation
of the upstream response. This behavior has not changed from previous versions
of this module.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes AUTHORS README examples
%perl_vendor_privlib/W*

%changelog
