%def_without test
%define module_name WWW-Wunderground-API
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(Hash/AsObject.pm) perl(JSON.pm) perl(JSON/MaybeXS.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moo.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(URI.pm) perl(XML/Simple.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Use Weather Underground's JSON/XML API
Group: Development/Perl
License: perl
URL: https://github.com/nebulous/WWW-Wunderground-API

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NEBULOUS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Connects to the Weather Underground JSON/XML service and parses the data
into something usable. The entire response is available in Hash::AsObject form, so
any data that comes from the server is accessible. Print a Data::Dumper of ->data
to see all of the tasty data bits.

    use WWW::Wunderground::API;

    #location
    my $wun = new WWW::Wunderground::API('Fairfax, VA');

    #or zipcode
    my $wun = new WWW::Wunderground::API('22030');

    #or airport identifier
    my $wun = new WWW::Wunderground::API('KIAD');

    #using the options

    my $wun = new WWW::Wunderground::API(
      location=>'22152',
      api_key=>'my wunderground api key',
      auto_api=>1,
      cache=>Cache::FileCache->new({ namespace=>'wundercache', default_expires_in=>2400 }) #A cache is probably a good idea.
    );


    #Check the wunderground docs for details, but here are just a few examples

    #the following $t1-$t6 are all equivalent:
    $wun->location(22152);

    $t1 = $wun->api_call('conditions')->temp_f
    $t2 = $wun->api_call('conditions', 22152)->temp_f
    $t3 = $wun->api_call('conditions', {location=>22152})->temp_f
    $t4 = $wun->api_call('conditions', location=>22152)->temp_f
    $t5 = $wun->conditions->temp_f
    $t6 = $wun->temp_f

    print 'The temperature is: '.$wun->conditions->temp_f."\n";
    print 'The rest of the world calls that: '.$wun->conditions->temp_c."\n";
    my $sat_gif = $wun->satellite; #image calls default to 300x300 gif
    my $rad_png = $wun->radar( format=>'png', width=>500, height=>500 ); #or pass parameters to be specific
    my $rad_animation = $wun->animatedsatellite(); #animations are always gif
    print 'Record high temperature year: '.$wun->almanac->temp_high->recordyear."\n";
    print "Sunrise at:".$wun->astronomy->sunrise->hour.':'.$wun->astronomy->sunrise->minute."\n";
    print "Simple forecast:".$wun->forecast->simpleforecast->forecastday->[0]{conditions}."\n";
    print "Text forecast:".$wun->forecast->txt_forecast->forecastday->[0]{fcttext}."\n";
    print "Long range forecast:".$wun->forecast10day->txt_forecast->forecastday->[9]{fcttext}."\n";
    print "Chance of rain three hours from now:".$wun->hourly->[3]{pop}."%%\n";
    print "Nearest airport:".$wun->geolookup->nearby_weather_stations->airport->{station}[0]{icao}."\n";

    #Conditions is autoloaded into the root of the object
    print "Temp_f:".$wun->temp_f."\n";


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.pod Changes
%perl_vendor_privlib/W*

%changelog
