# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name WeakRef
%define upstream_version 0.01

%{?perl_default_filter}

Name:		perl-%{upstream_name}
Version:	%{upstream_version}
Release:	alt7_32
Summary:	An API to the Perl weak references
License:	GPL or Artistic
Group:		Development/Perl
URL:            https://metacpan.org/release/%{upstream_name}
Source:         https://cpan.metacpan.org/modules/by-module/WeakRef/%{upstream_name}-%{upstream_version}.tar.bz2

Buildrequires:	perl-devel
Source44: import.info


%description
A patch to Perl 5.005_55 by the author implements a core API for weak
references. This module is a Perl-level interface to that API, allowing weak
references to be created in Perl.

A weak reference is just like an ordinary Perl reference except that it isn't
included in the reference count of the thing referred to. This means that once
all references to a particular piece of data are weak, the piece of data is
freed and all the weak references are set to undef. This is particularly useful
for implementing circular data structures without memory leaks or caches of
objects.

%prep
%setup -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
%{__make} test

%install
%makeinstall_std

%files 
%doc Changes README
%{perl_vendor_archlib}/*


%changelog
