%define module_name Weasel
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTML/Selector/XPath.pm) perl(List/Util.pm) perl(Module/Runtime.pm) perl(Moose.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Weasel/DriverRole.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.31
Release: alt1
Summary: PHP's Mink inspired multi-protocol web-testing library for Perl
Group: Development/Perl
License: perl
URL: https://weasel.pm/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EH/EHUELS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module abstracts away the differences between the various
web-driver protocols, like the Mink project does for PHP.

While heavily inspired by Mink, `Weasel' aims to improve over it
by being extensible, providing not just access to the underlying
browser, yet to provide building blocks for further development
and abstraction.

the Pherkin::Extension::Weasel manpage provides integration with
the Test::BDD::Cucumber manpage (aka pherkin), for BDD testing.

For the actual page interaction, this module needs a driver to
be installed.  Currently, that means the Weasel::Driver::Selenium2 manpage.
Other driver implementations, such as Sahi
can be independently developed and uploaded to CPAN, or contributed.
(We welcome and encourage both!)

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md CHANGES LICENSE README
%perl_vendor_privlib/W*

%changelog
