%define module_name Weasel-Driver-Mock
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Compare.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(IO/Scalar.pm) perl(MIME/Base64.pm) perl(Moose.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Warnings.pm) perl(Weasel.pm) perl(Weasel/Session.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Weasel driver to mock a real driver for testing purposes
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EH/EHUELS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module implements the the Weasel::DriverRole manpage protocol,
mimicing a true web driver session. The concept has been
very much inspired by DBD::Mock.

The `states' attribute of a Weasel::Driver::Mock object contains
a reference to an array of hashes. Each hash describes a `state'.

   [ {
        cmd => 'get', args => [ 'http://localhost/index' ]
     },
     {
        cmd => 'find', args => [ '//div[@id="help-me"]' ],
        ret => {
           id => 'abc',
        },
     },
     {
        cmd => 'find_all', args => [ '//div' ],
        ret_array => [
           { id => 'abc' },
           { id => 'def' },
        ],
     },
     {
         cmd => 'click', args => [ 'abc' ],
         err => 'Element not visible on the page',
     },
     ...
   ]

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE CHANGES README
%perl_vendor_privlib/W*

%changelog
