# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(DateTime/Format/HTTP.pm) perl(Kavorka.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Paws.pm) perl(Test/Compile.pm) perl(Test/More.pm) perl(Types/Standard.pm) perl(Web/AssetLib.pm)
# END SourceDeps(oneline)
%define module_name Web-AssetLib-OutputEngine-S3
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.042
Release: alt1
Summary: allows exporting an asset or bundle to an AWS S3 Bucket
Group: Development/Perl
License: see LICENSE
URL: https://github.com/ryan-lang/Web-AssetLib-OutputEngine-S3

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RL/RLANG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
my $library = My::AssetLib::Library->new(
        output_engines => [
            Web::AssetLib::OutputEngine::S3->new(
                access_key  => 'AWS_ACCESS_KEY',
                secret_key  => 'AWS_SECRET_KEY',
                bucket_name => 'S3_BUCKET_NAME',
                region      => 'S3_BUCKET_REGION'
            )
        ]
    );

    $library->compile( ..., output_engine => 'S3' );

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/W*

%changelog
