%define module_name WebDyne
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Apache2/Const.pm) perl(Apache2/Log.pm) perl(Apache2/Response.pm) perl(Apache2/ServerUtil.pm) perl(Apache2/SubRequest.pm) perl(CGI.pm) perl(Digest/MD5.pm) perl(Env/Path.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/Entities.pm) perl(HTML/Tagset.pm) perl(HTML/TreeBuilder.pm) perl(HTTP/Status.pm) perl(Pod/Usage.pm) perl(Storable.pm) perl(Test/More.pm) perl(Text/Template.pm) perl(Tie/IxHash.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.250
Release: alt1
Summary: create web pages with embedded Perl
Group: Development/Perl
License: gpl
URL: https://webdyne.org

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AS/ASPEER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
WebDyne is a Perl based dynamic HTML engine. It works with web servers (or from the command line) to render HTML
documents with embedded Perl code.

Once WebDyne is installed and initialised to work with a web server, any file with a .psp extension is treated as a
WebDyne source file. It is parsed for WebDyne or CGI.pm pseudo-tags (such as <perl> and <block> for WebDyne, or
<start_html>, <popup_menu> for CGI.pm) which are interpreted and executed on the server. The resulting output is then
sent to the browser.

Pages are parsed once, then optionally stored in a partially compiled format - speeding up subsequent processing by
avoiding the need to re-parse a page each time it is loaded. WebDyne works with common web server persistant/resident
Perl modules such as mod_perl and FastCGI to provide fast dynamic content.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc ChangeLog README LICENSE doc
%perl_vendor_privlib/W*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
