# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(DB_File.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    WebFetch
%define upstream_version 0.13

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_9

Summary:    Perl module to download and save information from the Web
License:    GPL
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    http://cpan.perl.org/modules/by-module/WebFetch/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(Date/Calc.pm)
BuildRequires: perl(Exception/Class.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(HTML/LinkExtor.pm)
BuildRequires: perl(HTTP/Request.pm)
BuildRequires: perl(LWP/UserAgent.pm)
BuildRequires: perl(Locale/Country.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(XML/Atom/Client.pm)
BuildRequires: perl(XML/Parser.pm)
BuildRequires: perl(XML/RSS.pm)
BuildRequires: perl(Template.pm)
BuildRequires: perl-libwww-perl
BuildArch:  noarch

Requires:   perl-Locale-Codes
Requires:   perl-Date-Calc
Requires:   perl-XML-Parser
Source44: import.info

%description
WebFetch is a Perl module to download and save information from the Web, and
to display on the Web.  It will download from sites such as CNet, CNN,
Freshmeat, Slashdot, LinuxToday, Yahoo, and more.  It can even export your
site's news for other sites to include in their web pages.

%prep 
%setup -n %{upstream_name}-%{upstream_version}

%build
CFLAGS="$RPM_OPT_FLAGS" /usr/bin/perl Makefile.PL INSTALLDIRS=vendor
make

%check
rm -f t/pod-coverage.t
make test

%install
make PREFIX=$RPM_BUILD_ROOT%{_prefix} DESTDIR=$RPM_BUILD_ROOT install

%files
%doc Changes META.yml  README TODO
%{perl_vendor_privlib}/WebFetch*
%{perl_vendor_privlib}/*.pod


%changelog
