%define module_name WebService-Discord-Webhook
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(HTTP/Tiny.pm) perl(JSON/PP.pm) perl(MIME/Base64.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.10
Release: alt1
Summary: A module for posting messages to Discord chat service
Group: Development/Perl
License: artistic_2
URL: https://github.com/greg-kennedy/p5-WebService-Discord-Webhook

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GR/GREGK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module posts messages to the Discord chat service, using their Webhook
interface.  Webhooks are a simple way to add post-only functions to external
clients, without the need to create a full-fledged client or "bot".

Normally, Webhooks are used to issue a notification to chat channels when an
external event from another site or service occurs, e.g. when a commit is made
to a Git repository, a story is posted to a news site, or a player is fragged
in a game.

An example Discord Webhook URL looks like this:

    https://discordapp.com/api/webhooks/2237...5344/3d89...cf11

where the first magic number ("2237...5344") is the `id' and the second
("3d89...cf11") is the `token'.

For more information on Discord Webhooks, see the Discord API documentation
located at https://discordapp.com/developers/docs/resources/webhook.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.pod
%perl_vendor_privlib/W*

%changelog
