# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Response.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(LWP/UserAgent.pm) perl(Test/Exception.pm) perl(Test/MockModule.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name WebService-Freesound
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Perl wrapper around Freesound OAuth2 API!
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AN/ANDYCRAGG/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module provides a Perl wrapper around the https://Freesound.org RESTful API.

Freesound is a collaborative database of Creative Commons Licensed sounds. It allows
you to browse, download and share sounds.  This Perl wrapper at present allows you
'read-only' access to Freesound, ie browse and download.  Upcoming versions could provide
upload, describe and edit your own sounds (though I expect it might just be easier to use
their website for this).

The complete Freesound API is documented at https://www.freesound.org/docs/api/index.html

In order to use this Perl module you will need get an account at Freesound
(https://www.freesound.org/home/register/) and then to register your application with them
at https://www.freesound.org/apiv2/apply. Your application will then be given a client ID and
a client secret which you will need to use to get OAuth2 authorisation.

The OAuth2 Dance is described at Freesound, https://www.freesound.org/docs/api/authentication.html
and officially at RFC6749.  It is a three step process as 
suggested above.

This module should look after the authorisation once done, ie when the expiry time arrives
it can automatically refresh the tokens.  The auth tokens are therefore kept as a file specified by
"*session_file*", which should be read-only by you/www-data only.

When downloading a sound sample from Freesound a progress meter is available in "*counter_file*"
which is useful in web contexts as a progress bar.  Format of the file is :

<bytes-written>:<byes-total>:<percentage>
# for example "10943051:12578220:87", ie 87%% of 12578220 bytes written.

This is optional.

Also the download will download the sample file as its name and type suffix (some Freesound names have 
suffixes, some don't), so something like "/var/www/myapp/downloads/Pretty tune on piano.wav", 
".../violin tremolo G5.aif" etc.

The query method allows you to put any text string into its parameter so that you have the full
capabilities of Freesound search, filter, sort etc, as described here :
https://www.free...
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc License README.md README Changes
%perl_vendor_privlib/W*

%changelog
