# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Tiny.pm) perl(JSON.pm) perl(Moo.pm) perl(Scalar/Util.pm) perl(strictures.pm)
# END SourceDeps(oneline)
%filter_from_requires /^perl.WebService.Geocodio.Fields.Census.pm./d
%filter_from_requires /^perl.WebService.Geocodio.Fields.Timezone.pm./d
%filter_from_requires /^perl.WebService.Geocodio.Fields.StateLegislativeDistrict.Senate.pm./d
%filter_from_requires /^perl.WebService.Geocodio.Fields.StateLegislativeDistrict.House.pm./d
%filter_from_requires /^perl.WebService.Geocodio.Fields.StateLegislativeDistrict.pm./d
%filter_from_requires /^perl.WebService.Geocodio.Fields.SchoolDistrict.Unified.pm./d
%filter_from_requires /^perl.WebService.Geocodio.Fields.SchoolDistrict.Secondary.pm./d
%filter_from_requires /^perl.WebService.Geocodio.Fields.SchoolDistrict.Elementary.pm./d
%filter_from_requires /^perl.WebService.Geocodio.Fields.SchoolDistrict.pm./d
%filter_from_requires /^perl.WebService.Geocodio.Fields.CongressionalDistrict.pm./d
%define module_name WebService-Geocodio
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: A Perl interface to Geocod.io
Group: Development/Perl
License: perl
URL: https://metacpan.org/dist/WebService-Geocodio

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MALLEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use 5.014;
    use WebService::Geocodio;
    use WebService::Geocodio::Location;

    my $geo = WebService::Geocodio->new(
        api_key => $ENV{GEOCODIO_API_KEY}
    );

    # Wrigley Field
    my $loc = WebService::Geocodio::Location->new(
        number => 1060,
        postdirection => 'W',
        street => 'Addison',
        suffix => 'Street',
        city => 'Chicago',
        state => 'IL',
    );

    # Could add more than one thing here, even bare strings are OK
    # 20050 = zip code in Washington DC
    $geo->add_location($loc, '20050');

    $geo->add_field('timezone');

    # prints:
    # Chicago: 41.947205791667, -87.656316875, CST
    # Chicago: 41.947180613636, -87.657167363636, CST
    # Washington: 38.893311, -77.014647, EST
    map { say $_->city, ": ", $_->lat, ", ", $_->lng, ", " $_->fields->timezone->name } $geo->geocode();

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE
%perl_vendor_privlib/W*

%changelog
