%def_without test
%define module_name WebService-GoogleAPI-Client
%set_perl_req_method relaxed
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CHI.pm) perl(Carp.pm) perl(Config/JSON.pm) perl(Crypt/JWT.pm) perl(Data/Dump.pm) perl(Data/Dumper.pm) perl(Data/Printer.pm) perl(Exporter/Shiny.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Socket/SSL.pm) perl(List/SomeUtils.pm) perl(List/Util.pm) perl(Mojo/JWT.pm) perl(Mojo/JWT/Google.pm) perl(Mojolicious.pm) perl(Mojolicious/Plugin/OAuth2.pm) perl(Moo.pm) perl(Net/EmptyPort.pm) perl(Test2/Tools/HTTP.pm) perl(Test2/V0.pm) perl(strictures.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.27
Release: alt1
Summary: Google API Discovery and SDK
Group: Development/Perl
License: apache
URL: https://pscott-au.github.io/WebService-GoogleAPI-Client/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VE/VEESH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Access Google API Services using an OAUTH2 User Agent.

Includes Discovery, validation, authentication and API Access.

By default assumes gapi.json configuration in working directory with scoped Google project 
credentials and user authorization created by the goauth manpage.

    use WebService::GoogleAPI::Client;
    
    my $gapi_client = WebService::GoogleAPI::Client->new( debug => 1, gapi_json => 'gapi.json', user=> 'peter@pscott.com.au' );
    
    say $gapi_client->list_of_available_google_api_ids();

    my @gmail_endpoint_list =      $gapi_client->methods_available_for_google_api_id('gmail')

    if $gapi_agent->has_scope_to_access_api_endpoint( 'gmail.users.settings.sendAs.get' ) {
      say 'User has Access to GMail Method End-Point gmail.users.settings.sendAs.get';
    }

Package includes the goauth manpage CLI Script to collect initial end-user authorisation
to scoped services.

Note to intrepid hackers: Any method that isn't documented is considered
private, and subject to change in breaking ways without notice. (Although I'm a
pretty nice guy, and probably will leave a warning or something).

=begin html <a href="https://travis-ci.org/pscott-au//WebService-GoogleAPI-Client"><img alt="Build Status" src="https://api.travis-ci.org/pscott-au/WebService-GoogleAPI-Client.png?branch=master" /></a>
<a href="https://metacpan.org/pod/WebService::GoogleAPI::Client"><img alt="CPAN version" src="https://img.shields.io/cpan/v/WebService-GoogleAPI-Client.png" /></a>

=end html

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE CODE_OF_CONDUCT.md Changes CONTRIBUTING.md README.md README.txt examples
%perl_vendor_privlib/W*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
