%define module_version 0.02
%define module_name WebService-Instapaper
# BEGIN SourceDeps(oneline):
BuildRequires: perl(JSON.pm) perl(LWP/Protocol/https.pm) perl(Module/Build/Tiny.pm) perl(OAuth/Lite.pm) perl(OAuth/Lite/Consumer.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: A client for the Instapaper Full API
Group: Development/Perl
License: perl
URL: https://github.com/takebayashi/p5-WebService-Instapaper

Source0: http://cpan.org.ua/authors/id/T/TA/TAKEBAYAS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
WebService::Instapaper is a client for the Instapepr Full API (https://www.instapaper.com/api)

=over 4

=item new(\%%options)

Create new instance of this module. `%%options' should contain following keys: `consumer_key' and `consumer_secret'.

=item auth($username, $password)

Authenticate with given `$username' and `$password'.

=item token($access_token, $access_secret)

Set existing access token to the instance.

=item bookmarks(\%%options)

Return bookmark list. By default, it returns 25 bookmark items.

`%%options' may contain `limit' to specify the number of results.

    my @many_bookmarks = $client->bookmarks(limit => 100);

=item add_bookmark($url, \%%options)

Add new bookmark to Instapaper.

    $client->add_bookmark('http://www.example.org/');

    # with details
    $client->add_bookmark('http://www.example.org/', title => 'Example Article', description => 'This is an example.');

=item delete_bookmark($bookmark_id)

Delete the bookmark.

=item archive_bookmark($bookmark_id)

Archive the bookmark.

=back


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/W*

%changelog
