%define module_name WebService-Pixabay
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(Function/Parameters.pm) perl(LWP/Online.pm) perl(Module/Build.pm) perl(Moo.pm) perl(Test/More.pm) perl(WebService/Client.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.2.3
Release: alt1
Summary: Perl 5 interface to Pixabay API.
Group: Development/Perl
License: mit
URL: https://github.com/faraco/WebService-Pixabay

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FA/FARACO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use strict;
_use warnings;

_use WebService::Pixabay;
_
_my $pix = WebService::Pixabay->new(api_key => 'secret');
_
_# default searches
_my $img1 = $pix->image_search;
_my $vid1 = $pix->video_search;
_
_# print JSON structure using Data::Dumper's 'Dumper'
_$pix->show_data_structure($img1);
_$pix->show_data_structure($vid1);
_
_###################################################
_# The parameters of the method have the same name #
_# and default values as in Pixabay API docs       #
_###################################################

_# example custom image search and printing
_my $cust_img = $pix->image_search(
__q => 'cats dog',
__lang => 'es',
__response_group => 'high_resolution',
__image_type => 'illustration',
__category => 'animals',
__safesearch => 'true',
__order => 'latest',
__page => 2,
__per_page => 5,
__pretty => 'true'
_);

_$pix->show_data_structure($cust_img);

_# -or with video_search-

_# example custom video search and printing
_my $cust_vid = $pix->video_search(
__q => 'tree',
__lang => 'en',
__pretty => 'false',
__page => 3,
__order => 'popular'
_);

_$pix->show_data_structure($cust_vid);

_# Handling specific hashes and arrays of values from the image_search JSON
_# example retrieving webformatURL from each arrays
_my @urls = undef;
_
_foreach my $url (@{$cust_img->{hits}}) {

__# now has link of photo urls (non-preview photos)
__push(@urls, $url->{webformatURL});__
_}
_
_say $urls[3]; # image URL in the fourth row

_# Getting a specific single hash or array value from video_search JSON
_say $cust_vid->{hits}[0]{medium}{url};
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE CHANGES
%perl_vendor_privlib/W*

%changelog
