%define module_name Word2vec-Interface
BuildRequires: perl-podlators
BuildRequires: dos2unix
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Struct.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Type.pm) perl(IO/Uncompress/Gunzip.pm) perl(Sys/CpuAffinity.pm) perl(Text/Unidecode.pm) perl(XML/Twig.pm) perl(threads.pm) perl(threads/shared.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.039
Release: alt2
Summary: Interface module for word2vec.pm, word2phrase.pm, interface.pm modules and associated utilities.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CU/CUFFYCA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Word2vec::Interface is an interface module for utilization of word2vec, word2phrase, xmltow2v and their associated functions.
 This program houses a set of functions, modules and utilities for use with UMLS Similarity.

 XmlToW2v Features:
  - Compilation of a text corpus from plain or gun-zipped Medline XML files.
  - Multi-threaded text corpus compilation support.
  - Include text corpus articles via date range.
  - Include text corpus articles via title, abstract or both.
  - Compoundifying on-the-fly while building text corpus given a compound word file.

 Word2vec Features:
  - Word2vec training with user specified settings.
  - Manipulation of Word2vec word vectors. (Addition/Subtraction/Average)
  - Word2vec binary format to plain text file conversion.
  - Word2vec plain text to binary format file conversion.
  - Multi-word cosine similarity computation. (Sudo-compound word cosine similarity).

 Word2phrase Features:
  - Word2phrase training with user specified settings.

 Interface Features:
  - Word Sense Disambiguation via trained word2vec data.

%package scripts
Summary: %name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install
# trailing <CR> in interpreter: #!/usr/bin/perl<CR>
for dir in %buildroot%_bindir %buildroot%perl_vendor_archlib %buildroot%perl_vendor_privlib ; do
    if [ -d $dir ]; then
    	find $dir -type f -executable | while read f; do
	  case `file $f` in
	    *perl*) dos2unix $f ;;
	  esac
	done
    fi
done


%files
%doc README CHANGELOG
%perl_vendor_privlib/W*

%files scripts
%_bindir/*
%_man1dir/*
%_man1dir/*


%changelog
