Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CGI.pm) perl(CGI/Cookie.pm) perl(HTTP/Daemon.pm) perl(HTTP/Status.pm) perl(Pod/Coverage/TrustPod.pm) perl(Template.pm) perl(Test/CPAN/Meta/JSON.pm) perl(Test/Kwalitee.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Workflow
Version:        1.62
Release:        alt1_4
Summary:        Simple, flexible system to implement work-flows
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Workflow
Source0:        https://cpan.metacpan.org/authors/id/J/JO/JONASBN/Workflow-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  coreutils
BuildRequires:  findutils
# glibc-common for iconv
BuildRequires:  glibc-core glibc-timezones glibc-utils iconv
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)

# runtime
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Class/Accessor.pm)
BuildRequires:  perl(Class/Factory.pm)
BuildRequires:  perl(Class/Observable.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(DateTime.pm)
BuildRequires:  perl(DateTime/Format/Strptime.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(DBD/Mock.pm)
BuildRequires:  perl(DBI.pm)
BuildRequires:  perl(English.pm)
BuildRequires:  perl(Exception/Class.pm)
BuildRequires:  perl(File/Slurp.pm)
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(Log/Log4perl.pm)
BuildRequires:  perl(Safe.pm)
BuildRequires:  perl(Readonly.pm)
BuildRequires:  perl(XML/Simple.pm)

# tests
BuildRequires:  perl(blib.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(DBD/SQLite.pm)
BuildRequires:  perl(Env.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(if.pm)
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(IPC/Open3.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(List/MoreUtils.pm)
BuildRequires:  perl(Mock/MonkeyPatch.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)

# optional test #1
BuildRequires:  perl(Data/UUID.pm)
# optional test #2 -- not in Fedora yet
#BuildRequires:  perl(SPOPS)

#Requires:       perl(Class::Accessor) >= 0.18
#Requires:       perl(Class::Factory) >= 1
#Requires:       perl(Class::Observable) >= 1.04
#Requires:       perl(DateTime) >= 0.15
#Requires:       perl(DateTime::Format::Strptime) >= 1
#Requires:       perl(DBD::Mock) >= 0.1
#Requires:       perl(Exception::Class) >= 1.1
#Requires:       perl(Log::Dispatch) >= 2
#Requires:       perl(Log::Log4perl) >= 0.34
#Requires:       perl(Test::Exception)
#Requires:       perl(XML::Simple) >= 2






Source44: import.info
%filter_from_requires /perl(DBI.pm)/d
%filter_from_requires /perl(Data.UUID.pm)/d
%filter_from_requires /perl(File.Spec.Functions.pm)/d

%description
The 'Workflow' Perl module implements a standalone work-flow system. It
aims to be simple but flexible and therefore powerful. Each piece of
the work-flow system has a direct and easily stated job, and hopefully
you'll find that you can put the pieces together to create very useful
systems.

%prep
%setup -q -n Workflow-%{version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

%check
# note: these are a little noisy.
%{make_build} test

%files
%doc Changes.md README eg/ struct/
%doc --no-dereference LICENSE
%{perl_vendor_privlib}/*

%changelog
