# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Accessor.pm) perl(Date/Manip/Date.pm) perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/Table.pm) perl(LWP/UserAgent.pm) perl(Math/Round.pm) perl(Test/More.pm) perl(Text/Capitalize.pm) perl(XML/LibXML.pm) perl(XML/LibXML/NodeList.pm) perl(XML/LibXML/XPathContext.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name XBRL
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Perl extension for Reading Extensible Business Reporting Language documents 
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MG/MGANNON/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
XBRL provides an OO interface for reading Extensible Business Reporting Language
documents (XBRL docs).  

=over 4

=item new
	
	$xbrl_doc = XBRL->new ( { file="foo.xml", schema_dir="/var/cache/xbrl" } );

file -- This option specifies the main XBRL doc instance.

schema_dir -- allows the caller to specify a directory for storing ancillary
schemas required by the instance.  Specifying this directory means 
those schemas won't have to be downloaded each time an XBRL doc is 
parsed.  If no schema_dir is specified, the module will create a temporary
directory to store any needed schemas and delete it when the module goes 
out of scope.

=item get_html_report
	
Processes the XBRL doc into an HTML document.  
	
	$html = $xbrl_doc->get_html_report({ css_file => 'style.css'} ) 

The optional css_file allows an external CSS stylesheet to be included in the report 
for controlling the presentation of the report.  

	$html = $xbrl_doc->get_html_report({ css_block => $CSS } ) 

The optional css_block parameter takes a string of CSS instructions and includes 
them in the reports header section.

If neither option is specified, a default CSS style is included in the header of the report.

=item get_item_by_contexts 

	my $items = $xbrl_doc->get_item_by_contexts($context_id);

Return an array reference of XBRL::Items which share the same context.

=item get_item_all_contexts

	my $revenue_items = $xbrl_doc->get_item_all_contexts("us-gaap:Revenues");

Takes an item name and returns an array reference of all other items with the 
same name. 

=item get_all_items

	my $all_items = $xbrl_doc->get_all_items(); 

Returns an array reference to the list of all items.

=item get_item

	my $item = $xbrl_doc->get_item($item_name, $context_id) 

Returns an item identified by the its name and context.  Undef if no item 
of that description exists.

=item get_unit 

	my $unit = $xbrl_doc->get_unit($unit_id);


Returns unit identified by its id. 

=item get_all_contexts

	my $contexts = $xbrl_doc->get_all_contexts();

Returns a hash reference  where the keys are the context ids and the values are
XBRL::Context objects. 
  
=item get_context 

	my $context = $xbrl_doc->get_contexts($id);

Returns an XBRL::Context object based on the ID passed into the function.
	
=item get_taxonomy

	my $taxonomy = $xbrl_doc->get_taxonomy();

Returns an XBRL::Taxonomy instance based on the XBRL document. 


=item get_company 

	my $firm_name = $xbrl_doc->get_compan();

Returns a scalar with the name of the firm issuing the document.

=item report_type 
	
	my $report = $xbrl_doc->report_type()

Returns the report type (e.g. 10-Q).

=item report_date 

	my $date = $xbrl_doc->report_date()

Returns the date of the financial statement 

=item report_period 

Returns a scalar with the period (e.g. Q2). 


=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/X*

%changelog
