# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(HTTP/Tiny.pm) perl(Term/ReadLine.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name 	 XML-DT
%define upstream_version 0.69

%define req_xml_libxml_version %perl_convert_version 1.54

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_3

Summary:    A perl XML down translate module
License:    GPL
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/XML/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(HTTP/Simple.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(XML/DTDParser.pm)
BuildRequires: perl(XML/LibXML.pm)
BuildRequires: perl(parent.pm)
BuildArch:  noarch

Requires:   perl-XML-LibXML
Source44: import.info
%description
The XML::DT module is a perl module that does XML down translation.
Based on XML::LibXML, it is designed to perform simple and
compact translation/processing of XML documents.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
chmod 755 examples/*.pl
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor <<EOF
XML::LibXML
EOF
%make_build

%check
rm -f t/pod.t
%{__make} test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml  README examples
%{_bindir}/*
%{_mandir}/*/*
%{perl_vendor_privlib}/XML

%changelog
