# BEGIN SourceDeps(oneline):
BuildRequires: perl(Error.pm) perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir/Install.pm) perl(LWP/Simple.pm) perl(Test/More.pm) perl(URI.pm) perl(URI/file.pm) perl(base.pm) perl(overload.pm) perl(File/ShareDir.pm)
# END SourceDeps(oneline)
%define module_version 0.11
%define module_name XML-DTD
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Perl module for parsing XML DTDs
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/W/WO/WOHL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
XML::DTD is a Perl module for parsing XML DTDs. The following.  methods are provided.

=over 4

=item new

  $dtd = new XML::DTD [ ($val) ];

Constructs a new XML::DTD object.

Its parser will be validating, and hence will make parameter entity
substitutions, if the argument `$val' is present and has a boolean
value of true.

=item fread

  $dtd->fread(*FILEHANDLE [, $uri]);

Parse a DTD file. If the URI is passed, it is used as the URI for
the document entity.

=item sread

  $dtd->sread($string [, $uri]);

Parse DTD text in a string. If the URI is passed, it is used as the URI for
the document entity.

=item fwrite

  $dtd->fwrite(*FILEHANDLE);

Write the DTD to a file.

=item swrite

  $string = $dtd->swrite();

Return the DTD text as a string.

=item fwritexml

  $dtd->fwritexml(*FILEHANDLE);

Write an XML representation of the DTD to a file.

=item swritexml

  $string = $dtd->swritexml();

Return an XML representation of the DTD text as a string.

=item elementnames

  $elts = $dtd->elementnames;

Return an array of element names as an array reference.

=item element

  $eltobj = $dtd->element('elementname');

Return the element object (of type XML::DTD::Element) associated with
the specified name.

=item attlist

  $attlistobj = $dtd->attlist('elementname');

Return the attribute list object (of type XML::DTD::AttList) associated
with the specified name.

=item entman

  $entmanobj = $dtd->entman;

Return the associated entity manager object (of type
XML::DTD::EntityManager).

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/X*
%perl_vendor_privlib/auto/*
%files scripts
%_bindir/*
%_man1dir/*

%changelog
