Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
BuildRequires: gcc-c++ zlib-devel
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-XML-DifferenceMarkup
Version:        1.05
Release:        alt11_35
Summary:        XML diff and merge
# ppport.h:     GPL-1.0-or-later OR Artistic-1.0-Perl
# README:       GPL-1.0-or-later OR Artistic-1.0-Perl
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/XML-DifferenceMarkup
Source0:        https://cpan.metacpan.org/authors/id/V/VB/VBAR/XML-DifferenceMarkup-%{version}.tar.gz
# Use system CLFAGS
Patch0:         XML-DifferenceMarkup-1.05-Do-not-override-CCFLAGS.patch
# Adapt to GCC 13, proposed to an upstream, CPAN RT#145911
Patch1:         perl-XML-DifferenceMarkup-configure-c99.patch
# Adapt to libxml2 2.12.0 and GCC 14, proposed to the upstream, CPAN RT#151218
Patch2:         XML-DifferenceMarkup-1.05-Adapt-to-libxml2-2.12.0-and-gcc-14.patch
BuildRequires:  coreutils
BuildRequires:  diffmark-devel
BuildRequires:  findutils
# Makefile.PL generates a temporary Makefile.PL distribution with an XS
# file that links to probe libxml2 (with gcc) and diffmark (with g++)
# libraries.
BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:  libxml2-devel
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(DynaLoader.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(XML/LibXML.pm)
BuildRequires:  perl(XSLoader.pm)
# Tests only:
BuildRequires:  perl(Test.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(XML/LibXML.pm) >= 1.700



# Filter underspecified dependencies

Source44: import.info
%filter_from_requires /^perl(XML.LibXML.pm)/d

%description
This module implements an XML diff producing XML output. Both input and
output are DOM documents, as implemented by XML::LibXML.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
BuildArch:      noarch
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(XML/LibXML.pm) >= 1.700

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n XML-DifferenceMarkup-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1


%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1 OPTIMIZE="$RPM_OPT_FLAGS"
%{make_build}

%install
%{makeinstall_std}
find %{buildroot} -type f -name '*.bs' -size 0 -delete
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t testdata %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc Changes README
%dir %{perl_vendor_archlib}/auto/XML
%dir %{perl_vendor_archlib}/auto/XML/DifferenceMarkup
%{perl_vendor_archlib}/auto/XML/DifferenceMarkup/DifferenceMarkup.so
%dir %{perl_vendor_archlib}/XML
%{perl_vendor_archlib}/XML/DifferenceMarkup.pm

%files tests
%{_libexecdir}/%{name}

%changelog
