%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(ExtUtils/MakeMaker.pm) perl(IO/File.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(Test/Simple.pm) perl(XML/NamespaceSupport.pm) perl(XML/SAX.pm) perl(XML/SAX/Base.pm) perl(XML/SAX/ParserFactory.pm) perl(XML/SAX/Writer.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name XML-Filter-NSNormalise
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: SAX filter to normalise namespace prefixes
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GR/GRANTM/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This SAX (version 2) filter can be used to transform documents to ensure the
prefixes associated with namespaces are used consistently.

For example, feeding this document...

  <rdf:RDF
   xmlns="http://purl.org/rss/1.0/"
   xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
   xmlns:theonetruedublincore="http://purl.org/dc/elements/1.1/" >
    <theonetruedublincore:date>2002-10-08</theonetruedublincore:date>
  </rdf:RDF>

... through this filter ...

  XML::Filter::NSNormalise->new(
    Map => {
      'http://purl.org/dc/elements/1.1/' => 'dc'
    }
  )

... would produce this output ...

  <rdf:RDF
   xmlns="http://purl.org/rss/1.0/"
   xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
   xmlns:dc="http://purl.org/dc/elements/1.1/" >
    <dc:date>2002-10-08</dc:date>
  </rdf:RDF>

You can specify more than one namespace URI to prefix mapping, eg:

  XML::Filter::NSNormalise->new(
    Map => {
      'http://purl.org/dc/elements/1.1/' => 'dc',
      'http://www.w3.org/1999/02/22-rdf-syntax-ns#' => 'rdf',
      'http://purl.org/rss/1.0/modules/syndication/' => 'syn'
    }
  )

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/X*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
