# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Docker/CLI/Wrapper/Container.pm) perl(File/Find/Object.pm) perl(IO/All.pm) perl(Moose.pm) perl(Parse/RecDescent.pm) perl(Pod/Usage.pm) perl(Test/Run/CmdLine/Iface.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    XML-Grammar-Fiction
%define upstream_version 0.30.0

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Line iterator base
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/authors/id/S/SH/SHLOMIF/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Exception/Class.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(File/ShareDir.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(HTML/Entities.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(List/MoreUtils.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(MooX.pm)
BuildRequires: perl(MooX/late.pm)
BuildRequires: perl(Path/Tiny.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/XML/Ordered.pm)
BuildRequires: perl(XML/GrammarBase/Role/RelaxNG.pm)
BuildRequires: perl(XML/GrammarBase/Role/XSLT.pm)
BuildRequires: perl(XML/LibXML.pm)
BuildRequires: perl(XML/LibXSLT.pm)
BuildRequires: perl(XML/Writer.pm)
BuildRequires: perl(autodie.pm)
BuildRequires: perl(base.pm)
BuildRequires: perl(lib.pm)
BuildRequires: perl(parent.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(utf8.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
XML::Grammar::Fiction is a CPAN distribution that facilitates writing prose
fiction (= stories, novels, novellas, etc.). What it does is:

* 1. Converting a well-formed plain text format to a specialized XML
  format.

* 2. Converting the XML to DocBook/XML or directly to HTML for rendering.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL --installdirs=vendor
./Build

%check
./Build test

%install
./Build install --destdir=%{buildroot}

%files
%doc Changes LICENSE META.json META.yml  README
%{_bindir}/screenplay-text--list-images
%{_bindir}/screenplay-text-to-screenplay-xml
%{_bindir}/screenplay-text-to-xhtml5
%{_mandir}/man1/*
%perl_vendor_privlib/*

%changelog
