# BEGIN SourceDeps(oneline):
BuildRequires: perl(XML/Handler/Trees.pm) perl(XML/Simple.pm)
# END SourceDeps(oneline)
%define module_version 0.1
%define module_name XML-Handler-2Simple
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1
Release: alt1
Summary: SAX => XML::Simple handler
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RB/RBS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module accepts a SAX stream and converts it in to a Perl data structure
using XML::Simple.  The resulting object can be passed to
a subroutine and is returned after the parse.

For example, here's a SAX machine that outputs all of the records in
a record oriented XML file:

    use XML::Handler::2Simple;
    use XML::SAX::Machines qw( ByRecord );

    use IO::Handle;   ## Needed because LibXML uses it without loading it
    use Data::Dumper;

    $Data::Dumper::Indent    = 1;  ## Clean up Data::Dumper's output a wee bit
    $Data::Dumper::Terse     = 1;
    $Data::Dumper::Quotekeys = 1;

    ByRecord(
        XML::Handler::2Simple->new(
            DataHandler => sub {
                warn Dumper( $_[1] );
            },
        )
    )->parse_file( \*STDIN );


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%perl_vendor_privlib/X*

%changelog
