Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(ExtUtils/CBuilder.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(XML/Bare.pm) perl(XML/Hash.pm) perl(XML/Simple.pm) perl(XML/Twig.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Perform optional tests
%bcond_without perl_XML_Hash_LX_enables_optional_test

%global cpan_version 0.07
Name:           perl-XML-Hash-LX
# use 2-digits version because it is expected in the future
Version:        0.70.0
Release:        alt2_14
Summary:        Convert hash to XML and XML to hash using LibXML
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/XML-Hash-LX
Source0:        https://cpan.metacpan.org/authors/id/M/MO/MONS/XML-Hash-LX-%{cpan_version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/AutoInstall.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Types/Serialiser.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XML/LibXML.pm)
# Tests:
BuildRequires:  glibc-gconv-modules
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(lib/abs.pm)
BuildRequires:  perl(Test/More.pm)
%if %{with perl_XML_Hash_LX_enables_optional_test}
# Optional tests:
BuildRequires:  perl(Test/NoWarnings.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
%endif
Requires:       perl(Carp.pm)

# Remove under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(lib.abs.pm)/d

%description
This module is a companion for XML::LibXML. It operates with LibXML
objects, could return or accept LibXML objects, and may be used for
easy data transformations.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       glibc-gconv-modules
Requires:       perl(lib/abs.pm) >= 0.900
%if %{with perl_XML_Hash_LX_enables_optional_test}
Requires:       perl(Test/NoWarnings.pm)
%endif

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n XML-Hash-LX-%{cpan_version}
# Remove bundled modules
rm -rf ./inc/*
perl -i -ne 'print $_ unless m{^inc/}' MANIFEST
%if !%{with perl_XML_Hash_LX_enables_optional_test}
rm t/pod*
perl -i -ne 'print $_ unless m{^t/pod}' MANIFEST
%endif
# Fix shell bangs
for F in ex/* t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!.*perl}{$Config{startperl}}' "$F"
done
chmod +x t/*.t

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
%if %{with perl_XML_Hash_LX_enables_optional_test}
rm %{buildroot}%{_libexecdir}/%{name}/t/pod*
%endif
mkdir -p %{buildroot}%{_libexecdir}/%{name}/lib
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc --no-dereference LICENSE
%doc Changes ex README
%{perl_vendor_privlib}/*

%files tests
%{_libexecdir}/%{name}

%changelog
