Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-XML-Merge 
Version:        1.4
Release:        alt2_23
Summary:        Flexibly merge XML documents

License:        GPLv3
URL:            https://metacpan.org/release/XML-Merge
Source0:        https://cpan.metacpan.org/authors/id/P/PI/PIP/XML-Merge-%{version}.tgz
Patch1:         perl-XML-Merge-1.4-makefile.patch

BuildArch:      noarch 
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XML/Tidy.pm)
# Tests:
BuildRequires:  perl(Test.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
BuildRequires:  perl(XML/XPath.pm)
Source44: import.info

%description
This module inherits from XML::Tidy which in turn inherits from XML::XPath.
This ensures that Merge objects' indenting can be tidied up after any merge
operation since such modification usually spells the ruination of indentation.
Polymorphism allows Merge objects to be utilized as normal XML::XPath objects
as well.
The merging behavior is setup to combine separate XML documents according to
certain rules and configurable options. If both documents have root nodes which
are elements of the same name, the documents are merged directly. Otherwise,
one is merged as a child of the other. An optional XPath location can be
specified as the place to perform the merge. If no location is specified, the
merge is attempted at the first matching element or is appended as the new last
child of the other root if no match is found.


%prep
%setup -q -n XML-Merge-%{version}
%patch1 -p0


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build


%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} ';'
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null ';'
chmod -R u+w $RPM_BUILD_ROOT/*


%check
make test


%files
%doc README
%doc --no-dereference LICENSE 
%{perl_vendor_privlib}/*


%changelog
