# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    XML-NamespaceFactory
%define upstream_version 1.02

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_9

Summary:    Simple factory objects for SAX namespaced names
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/XML/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Test.pm)
BuildRequires: perl(overload.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(vars.pm)
BuildArch:  noarch
Source44: import.info

%description
Simply create a new XML::NamespaceFactory object with the namespace you
wish to use as its single parameter. If you wish to use the empty
namespace, simply pass in an empty string (but undef will not do).

Then, when you want to get a JClark name, call a method on that object the
name of which is the local name you wish to have. It'll return the JClark
notation for that local name in your namespace.

Unfortunately, some local names legal in XML are not legal in Perl. To
circumvent this, you can use the hash notation in which you access a key on
the object the name of which is the local name you wish to have. This will
work just as the method call name but will accept more characters. Note
that it does not check that the name you ask for is a valid XML name. This
form is more general but slower.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*

%changelog
