# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(ExtUtils/MakeMaker.pm) perl(HTML/TreeBuilder.pm) perl(XML/Parser.pm)
# END SourceDeps(oneline)
%define module_version 0.07
%define module_name XML-PYX
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: XML to PYX generator
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MS/MSERGEANT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
After reading about PYX on XML.com, I thought it was a pretty cool idea,
so I built this, to generate PYX from XML using perl. See
http://www.xml.com/pub/2000/03/15/feature/index.html for an excellent
introduction.

The package contains 2 usable packages, and 3 utilities that 
are probably currently more use than the module:

_pyx - a XML to PYX converter using XML::Parser
_pyxv - a Validating XML to PYX converter using XML::Checker::Parser
_pyxw - a PYX to XML converter
_pyxhtml - an HTML to PYX converter using HTML::TreeBuilder

All these utilities can be pipelined together, so you can have:

_pyx test.xml | grep -v "^-" | pyxw > new.xml

Which should remove all text from an XML file (leaving only tags).

The 2 packages are XML::PYX::Parser and XML::PYX::Parser::ToCSF. The
former is a direct subclass of XML::Parser that simply returns a PYX
string on a call to parse or parsefile. The latter stands for To
Currently Selected Filehandle. Instead of returning a string, it sends
output directly to the currently selected filehandle. This is much better
for pipelined utilities for obvious reasons.

There's a special variable: $XML::PYX::Lame. Set it to 1 to use a "Lame"
parser that simply uses regexps. This is useful, for example, if you are
changing the input to invalid XML for some reason. You can then use
$XML::PYX::Lame = 1 to enable the non-xml parser. It does check for some
things, like balanced tags, but otherwise it's pretty lame :)

Lame mode is enabled for pyx and pyxw with the -l option.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/X*

%files scripts
%_bindir/*

%changelog
