Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(XML/RSS.pm) perl-podlators
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-XML-RSS-LibXML
Version:        0.3105
Release:        alt2_28
Summary:        XML::RSS with XML::LibXML
License:        GPL-1.0-or-later OR Artistic-1.0-Perl

URL:            https://metacpan.org/release/XML-RSS-LibXML
Source0:        https://cpan.metacpan.org/authors/id/D/DM/DMAKI/XML-RSS-LibXML-%{version}.tar.gz
BuildArch:      noarch
# Build
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(CPAN/Meta.pm)
BuildRequires:  perl(CPAN/Meta/Prereqs.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(utf8.pm)
# Runtime
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Class/Accessor/Fast.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(DateTime/Format/Mail.pm)
BuildRequires:  perl(DateTime/Format/W3CDTF.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(UNIVERSAL/require.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XML/LibXML.pm)
BuildRequires:  perl(XML/LibXML/XPathContext.pm)
# Test Suite
%if 0%{?fedora} > 34 || 0%{?rhel} > 8
BuildRequires:  glibc-gconv-modules
%endif
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(Test/More.pm)
# Optional Tests
BuildRequires:  perl(Test/Differences.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/Warn.pm)
# Dependencies
Requires:       perl(constant.pm)


Source44: import.info

%description
XML::RSS::LibXML uses XML::LibXML (libxml2) for parsing RSS instead of
XML::RSS' XML::Parser (expat), while trying to keep interface compatibility
with XML::RSS.

%prep
%setup -q -n XML-RSS-LibXML-%{version}

%build
/usr/bin/perl Build.PL --installdirs=vendor
./Build

%install
./Build install --destdir=%{buildroot} --create_packlist=0
# %{_fixperms} -c %{buildroot}

%check
./Build test

%files
%doc Changes README.md
%doc --no-dereference LICENSE
%{perl_vendor_privlib}/XML*

%changelog
