# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Encode.pm) perl-Module-Build perl-devel perl-podlators
# END SourceDeps(oneline)
Name:		perl-XML-Rules
Version:	1.16
Release:	alt1_4
Summary:	Parse XML and specify what and how to keep/process for individual tags
License:	GPL+ or Artistic
Group:		Development/Perl
URL:		http://search.cpan.org/dist/XML-Rules
Source0:	http://search.cpan.org/CPAN/authors/id/J/JE/JENDA/XML-Rules-%{version}.tar.gz
Patch0:		XML-Rules-1.10-add-shebang.patch
BuildArch:	noarch

# build requirements
BuildRequires:	perl(Module/Build.pm)

# module requirements
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(constant.pm)
BuildRequires:	perl(Exporter.pm)
BuildRequires:	perl(Scalar/Util.pm)
BuildRequires:	perl(XML/Parser.pm)
BuildRequires:	perl(XML/Parser/Expat.pm)

# test requirements
BuildRequires:	perl(Data/Dump.pm)
BuildRequires:	perl(Test/More.pm)
BuildRequires:	perl(Test/Pod.pm)
BuildRequires:	perl(Test/Pod/Coverage.pm)
Source44: import.info



%description
The XML::Rules module provides an API layer on top of XML::Parser.  It
allows you to specify rules that are subroutines to be run once a tag
is fully parsed and either process the data from the tag itself and
its children or specify what parts of the data and how to add to the
data structure being built for the parent tag.

%prep
%setup -q -n XML-Rules-%{version}

# fix end of line encoding
find . -type f -exec sed -i 's/\r//' {} \;

# the patch assumes the end of lines have already been fixed
%patch0 -p1

%build
%{__perl} Build.PL --install_path bindoc=%_man1dir --installdirs vendor
./Build

%install

./Build install destdir=$RPM_BUILD_ROOT create_packlist=0

# %{_fixperms} $RPM_BUILD_ROOT/*

%check
./Build test

%files
%doc Changes README example LICENSE
%{perl_vendor_privlib}/XML/
%{_bindir}/dtd2XMLRules.pl
%{_bindir}/xml2XMLRules.pl

%changelog
