%define module_version 0.05
%define module_name XML-TiePYX
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators perl(XML/Parser.pm)

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Read or write XML data in PYX format via tied filehandle
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/E/EB/EBOHLMAN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
XML::TiePYX lets you use a tied filehandle to read from or write to an XML 
file or string.  PYX is a line-oriented, parsed representation of XML 
developed by Sean McGrath (http://www.pyxie.org).  Each line corresponds to 
one "event" in the XML, with the first character indicating the type of 
event:

=over 4

=item (

The start of an element; the rest of the line is its name.

=item A

An attribute; the rest of the line is the attribute's name, a space, and 
its value.

=item )

The end of an element; the rest of the line is its name.

=item -

Literal text (characters).  The rest of the line is the text.

=item ?

A processing instruction.  The rest of the line is the instruction's 
target, a space, and the instruction's value.

=back

Newlines in attribute values, text, and processing instruction values are 
represented as the literal sequence '\n' (that is, a backslash followed by 
an 'n').  By default, consecutive runs of characters are always gathered 
into a single text event when reading, but this behavior can be disabled.  
Comments are *not* available through PYX.

Just as SAX is an API well suited to "push"-mode XML parsing, PYX is well- 
suited to "pull"-mode parsing where you want to capture the state of the 
parse through your program's flow of code rather than through a bunch of 
state variables.  This module uses incremental parsing to avoid the need to 
buffer up large numbers of events.

This module implements an (unofficial) extension to the PYX format to allow 
namespace processing.  If namespaces are enabled, an element or attribute 
name will be prefixed by its namespace URI (*NOT* any namespace prefix used 
in the document) enclosed in curly braces.  A name with no namespace will 
be prefixed with {}.  At the present time, this module does not implement 
namespace processing in output mode; attempting to write '(', ')', or 'A' 
lines that contain a namespace URI in curly braces will merely result in 
generating ill-formed element or attribute names.



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/X*

%changelog
