%define module_name XML-XPath-Helper-Const
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(XML/LibXML.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: The great new XML::XPath::Helper::Const!
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AA/AAHAZRED/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides some precompiled XPath expressions (refer to
the XML::LibXML::XPathExpression manpage for details about this).

The provided constants are:

=over

=item `XPATH_SIMPLE_LIST'

Selects the "simple list nodes" contained in the current node; i.e. the
nodes that contain at least one child node, all the child nodes have the same
name and no child node has child nodes again.

Example:

    my $dom = XML::LibXML->load_xml(string => <<'EOT');
       <root>
         <findthis>
           <entry>a</entry>
           <entry>b</entry>
           <entry>c</entry>
         </findthis>
         <ignorethis>
           <foo>a</foo>
           <bar>b</bar>
         </ignorethis>
         <ignorethat>
           <child>
             <childofchild></childofchild>
           </child>
         </ignorethat>
         <simpletag>blah</simpletag>
       </root>
   EOT
    my @nodes = $dom->documentElement->findnodes(XPATH_SIMPLE_LIST);

Array `@nodes' contains a single node: `<findthis>'

=item `XPATH_SIMPLE_TAGS'

Find all nodes that have no child nodes.

=item `XPATH_NESTED_TAGS'

Find all nodes that have at least one child node.

=back




%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/X*

%changelog
