%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Linux/MemInfo.pm) perl(Proc/ProcessTable.pm) perl-podlators swig
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define         ver 2.7.0
%define         PatchLevel 0

Name:           perl-XML-Xerces
Version:        %{ver}_%{PatchLevel}
Release:        alt11_48
Summary:        Perl API to Xerces XML parser

License:        ASL 2.0
URL:            http://xerces.apache.org/xerces-p/
Source0:        http://www.apache.org/dist/xerces/p/XML-Xerces-%{ver}-%{PatchLevel}.tar.gz
Patch0:         %{name}-%{ver}-%{PatchLevel}-perl510.patch
Patch1:         cflags5.14.patch

BuildRequires:  gcc-c++
BuildRequires:  perl-devel
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Env.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  xerces-c27-devel >= %{ver}
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(DynaLoader.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(overload.pm)
# Tests:
BuildRequires:  perl(base.pm)
BuildRequires:  perl(blib.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(subs.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(utf8.pm)
Source44: import.info


%description
XML::Xerces is the Perl API to the Apache project's Xerces XML parser. It is
implemented using the Xerces C++ API, and it provides access to most of the C++
API from Perl.
Because it is based on Xerces-C, XML::Xerces provides a validating XML parser
that makes it easy to give your application the ability to read and write XML
data. Classes are provided for parsing, generating, manipulating, and
validating XML documents. XML::Xerces is faithful to the XML 1.0 recommendation
and associated standards (DOM levels 1, 2, and 3, SAX 1 and 2, Namespaces, and
W3C XML Schema). The parser provides high performance, modularity, and
scalability, and provides full support for Unicode.
XML::Xerces implements the vast majority of the Xerces-C API. The exception is
some functions in the C++ API which either have better Perl counterparts (such
as file I/O) or which manipulate internal C++ information that has no role in
the Perl module. 


%prep
%setup -q -n XML-Xerces-%{ver}-%{PatchLevel}
%patch0 -p1
%patch1 -p1

%build
%add_optflags -Wno-error=return-type
export XERCESCROOT=%{_prefix}
export XERCES_LIB=%{_libdir}/xerces-c-%{ver}/
export XERCES_INCLUDE=%{_includedir}/xercesc-%{ver}
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="$RPM_OPT_FLAGS"
%make_build


%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} ';'
find $RPM_BUILD_ROOT -type f -name '*.bs' -a -size 0 -exec rm -f {} ';'
find $RPM_BUILD_ROOT -type d -depth -exec rmdir {} 2>/dev/null ';'
chmod -R u+w $RPM_BUILD_ROOT/*


%check
make test


%files
%doc Changes FAQ LICENSE README TODO docs samples
%{perl_vendor_archlib}/XML
%{perl_vendor_archlib}/auto/XML
%exclude %{perl_vendor_archlib}/auto/Handler


%changelog
