%define module_name XS-Object-Magic
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(DynaLoader.pm) perl(ExtUtils/Depends.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Scalar/Util.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(ok.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt4
Summary: Opaque, extensible XS pointer backed objects using C<sv_magic>
Group: Development/Perl
License: perl
URL: https://github.com/karenetheridge/XS-Object-Magic

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETHER/%{module_name}-%{version}.tar.gz

%description
package MyObject;

	use XS::Object::Magic;

	sub new {
		my $class = shift;

		# create any object representation you like
		my $self = bless {}, $class;

		$self->build_struct;

		return $self;
	}


	# or using Moose

	package MyObject;
	use Moose;

	sub BUILD {
		shift->build_struct;
	}


	# then in XS

	MODULE = MyObject  PACKAGE = MyObject

	void build_struct (SV *self)
		PREINIT:
			my_struct_t *thingy;
		CODE:
			thingy = create_whatever();

			/* note that we dereference self first. This
			 * can be done using an XS typemap of course */
			xs_object_magic_attach_struct(aTHX_ SvRV(self), thingy);


	void foo (SV *self)
		PREINIT:
			my_struct_t *thingy;
		INIT:
			thingy = xs_object_magic_get_struct_rv(aTHX_ self);
		CODE:
			my_struct_foo(thingy); /* delegate to C api */


	/* using typemap */
	void foo (my_struct_t *thingy)
		CODE:
			my_struct_foo(thingy);

	/* or better yet */
	PREFIX = my_struct_

	void
	my_struct_foo (thingy)
		my_struct_t *thingy;


	/* don't forget a destructor */
	void
	DESTROY (my_struct_t *thingy)
		CODE:
			Safefree(thingy);

			/* note that xs_object_magic_get_struct() will
			 * still return a pointe which is now invalid */



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README CONTRIBUTING
%perl_vendor_archlib/X*
%perl_vendor_autolib/*

%changelog
