%define module_name XT-Files
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Tiny.pm) perl(Cwd.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Temp.pm) perl(File/stat.pm) perl(Module/Load.pm) perl(Role/Tiny.pm) perl(Role/Tiny/With.pm) perl(Scalar/Util.pm) perl(Test/Builder.pm) perl(Test/Builder/Tester.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(constant.pm) perl(lib.pm) perl(overload.pm) perl(parent.pm) perl(strict.pm) perl(version.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: standard interface for author tests to find files to check
Group: Development/Perl
License: open_source
URL: https://github.com/skirmess/XT-Files

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SK/SKIRMESS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Author tests often iterate over your distributions files to check them.
Unfortunately, every XT test uses its own code and defaults, to find the files
to check, which means they often don't fit the need of your distribution.
Common problems are not checking bin or script or, if they do, assuming
Perl files in bin or script end in `.pl'.

The idea of `XT::Files' is that it's the `Test's that know what they want
to check (e.g. module files), but it's the distribution that knows where
these files can be found (e.g. in the lib directory and in the t/lib
directory).

Without `XT::Files' you are probably adding the same code to multiple .t
files under xt that iterate over a check function of the test.

`XT::Files' is a standard interface that makes it easy for author tests to
ask the distribution for the kind of files it would like to test. And it can
easily be used for author tests that don't support `XT::Files' to have the
same set of files tested with every test.

Note: This is for author tests only. Your own distributions tests already
know which files to test.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes CONTRIBUTING LICENSE README
%perl_vendor_privlib/T*
%perl_vendor_privlib/X*

%changelog
