# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Class/Accessor/Fast.pm) perl(Class/Data/Inheritable.pm) perl(Config.pm) perl(Cwd.pm) perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Copy/Recursive.pm) perl(File/Find.pm) perl(File/ShareDir.pm) perl(File/Slurp.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON/Syck.pm) perl(LWP/Simple.pm) perl(Locale/Maketext.pm) perl(Locale/Maketext/Lexicon.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Object/Declare.pm) perl(Socket.pm) perl(Sys/Hostname.pm) perl(Template/Declare.pm) perl(Template/Declare/Tags.pm) perl(Test/More.pm) perl(Text/Diff.pm) perl(YAML.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.09
%define module_name XUL-App
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Nifty XUL apps in a XUL::App
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AG/AGENT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
XUL::App is a nifty Firefox extension development framework based on Perl. It has a lot of parallels with the Jifty manpage. In particular, this framework allows you to build real-world modern Firefox extensions using Perl. But the resulting XPI installation file is completely portable and contains *0* Perl.

This framework has the following highlights:

=over

=item *

the Jifty manpage love on the Firefox extension development land.

=item *

Building a realworld Firefox extension can be even much easier than GreaseMonkey hacks.

=item *

Use 100%% Perl to specify XUL layout via the Template::Declare manpage, no XML pain.

=item *

Automatic extension registration/unregistration for easy debugging. And no more frustration from Firefox's XUL/ext cache. (XUL::App will ensure the developer version defeats Firefox's cache.)

=item *

Transparent `jar'-based XPI bundling, no chrome.manifest, the install.rdf manpage, and zip panic. XUL::App generates all of them for you according to your (declarative) Perl code.

=item *

The resulting XPI file contains 0%% Perl and could run everywhere (Win32, Mac, Linux, and etc). It's a compiler-style framework.

=item *

I18N support via the the Locale::Maketext::Lexicon manpage module (same as the Jifty manpage, but
actually emulated by XUL's native I18N mechanism).

=back

Currently the module is still in alpha stage and we're in severe lack of documentation and tests. (Although a real-world fully-fledged Firefox extension named SearchAll (https://addons.mozilla.org/en-US/firefox/addon/5712) is already developed atop it.

You can get a lot of information from the slides that I used in the following talk:

http://agentzh.org/misc/slides/xulapp/xulapp.xul  (a JS-enabled Firefox is required to view these slides)

If you're having problems in displaying the slides given above, please try out the PowerPoint (PPT) version below:

http://agentzh.org/misc/slides/xulapp.ppt

or the PDF version:

http://agentzh.org/misc/slides/xulapp.pdf

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/X*
%perl_vendor_privlib/auto/*
%files scripts
%_bindir/*
%_man1dir/*

%changelog
